
-- ----------------------------
-- Table structure for category
-- ----------------------------

CREATE TABLE category  (
  id_category int(11) NOT NULL AUTO_INCREMENT,
  category varchar(255) DEFAULT NULL,
  PRIMARY KEY (id_category)
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of category
-- ----------------------------
INSERT INTO category VALUES (2, 'MANUFACTORY');
INSERT INTO category VALUES (3, 'COMPUTER');


-- ----------------------------
-- Table structure for status
-- ----------------------------

CREATE TABLE status  (
  id_status int(11) NOT NULL AUTO_INCREMENT,
  status varchar(50) DEFAULT NULL,
  PRIMARY KEY (id_status)
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of status
-- ----------------------------
INSERT INTO status VALUES (1, 'ACTIVE');
INSERT INTO status VALUES (2, 'INACTIVE');
INSERT INTO status VALUES (3, 'PAID');


-- ----------------------------
-- Table structure for supplier
-- ----------------------------

CREATE TABLE supplier  (
  id_supplier int(11) NOT NULL AUTO_INCREMENT,
  supplier_name varchar(75) DEFAULT NULL,
  address varchar(150) DEFAULT NULL,
  telephone varchar(15) DEFAULT NULL,
  contact varchar(75) DEFAULT NULL,
  email varchar(50) DEFAULT NULL,
  website varchar(75) DEFAULT NULL,
  PRIMARY KEY (id_supplier)
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of supplier
-- ----------------------------
INSERT INTO supplier VALUES (3, 'TICONSULTING', 'Colonia Escalón #533, San Salvador', '23653265', 'CARLOS GUZMÁN', 'cguzman@ticonsulting.biz', 'www.ticonsulting.biz');



-- ----------------------------
-- Table structure for loss
-- ----------------------------

CREATE TABLE loss  (
  id_loss int(11) NOT NULL AUTO_INCREMENT,
  dateloss datetime(0) NULL DEFAULT NULL,
  id_status int(11) NOT NULL,
  total decimal(10, 2) NULL DEFAULT NULL,
  PRIMARY KEY (id_loss),
  INDEX FK_loss_cState(id_status),
  CONSTRAINT loss_ibfk_1 FOREIGN KEY (id_status) REFERENCES status (id_status) ON DELETE RESTRICT ON UPDATE RESTRICT
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for product
-- ----------------------------
CREATE TABLE product (
  id_product int(11) NOT NULL AUTO_INCREMENT,
  product_name varchar(50) COLLATE utf8_bin DEFAULT NULL,
  product_code varchar(50) COLLATE utf8_bin DEFAULT NULL,
  id_status int(11) DEFAULT NULL,
  dateproduct datetime DEFAULT NULL,
  product_value decimal(10,2) DEFAULT NULL,
  product_cost decimal(10,2) DEFAULT NULL,
  discount decimal(10,2) DEFAULT '0.00',
  stock int(11) DEFAULT NULL,
  id_category int(11) DEFAULT NULL,
  image blob,
  PRIMARY KEY (id_product),
  INDEX IX_product(product_code),
  INDEX FK_product_cState(id_status),
  INDEX id_category(id_category),
  CONSTRAINT product_ibfk_1 FOREIGN KEY (id_category) REFERENCES category (id_category) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT product_ibfk_2 FOREIGN KEY (id_status) REFERENCES status (id_status) ON DELETE RESTRICT ON UPDATE RESTRICT
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of product
-- ----------------------------
INSERT INTO product VALUES (1, 'S-EXECUTIVE', 'A00001', 1, '2019-09-19 12:01:42', 125.00, 90.00, 0.00, 110, 2, 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);
INSERT INTO product VALUES (2, 'NOTEBOOK HP', 'A00002', 1, '2019-09-19 14:29:25', 950.00, 800.00, 0.00, 51, 3, 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);
INSERT INTO product VALUES (3, 'TABLET', 'A00003', 1, '2019-09-19 14:35:09', 550.00, 425.00, 0.00, 8, 3, 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);
INSERT INTO product VALUES (4, 'EXTERNAL HD', 'A00004', 1, '2019-09-19 14:36:10', 125.00, 75.00, 0.00, 47, 3, 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);
INSERT INTO product VALUES (5, 'PRINTER', 'A00005', 1, '2019-09-19 14:36:37', 125.00, 75.00, 0.00, 183, 3, 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);
INSERT INTO product VALUES (6, 'MULTIFUNCTION', 'A00006', 1, '2019-09-19 14:37:11', 285.00, 200.00, 0.00, 96, 3, 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);
INSERT INTO product VALUES (7, 'CAMERA', 'A00007', 1, '2019-09-19 14:37:28', 205.00, 165.00, 0.00, 98, 3, 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);
INSERT INTO product VALUES (8, 'IPHONE', 'A00008', 1, '2019-09-19 14:37:47', 1025.00, 750.00, 0.00, 99, 3, 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);
INSERT INTO product VALUES (10, 'MOUSE', 'A00010', 1, '2019-09-26 20:32:59', 50.00, 35.00, 0.00, 91, 3, 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);
INSERT INTO product VALUES (11, 'SCANNER', 'A00011', 1, '2019-09-30 08:37:14', 95.00, 60.00, 0.00, 0, 3, 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);

-- ----------------------------
-- Table structure for sales
-- ----------------------------
CREATE TABLE sales (
  id_sales int(11) NOT NULL AUTO_INCREMENT,
  sales_price decimal(10,2) DEFAULT NULL,
  sales_discount decimal(10,2) DEFAULT NULL,
  total decimal(10,2) DEFAULT NULL,
  datesales datetime DEFAULT NULL,
  id_status int(11) DEFAULT NULL,
  PRIMARY KEY (id_sales),
  CONSTRAINT sales_ibfk_1 FOREIGN KEY (id_status) REFERENCES status (id_status)
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;


INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(1, 0.00, 0.00, 0.00, '2019-09-19 22:01:13', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(2, 0.00, 0.00, 0.00, '2019-09-19 22:38:38', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(3, 0.00, 0.00, 0.00, '2019-09-19 22:38:38', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(4, 0.00, 0.00, 0.00, '2019-09-19 22:41:29', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(5, 0.00, 0.00, 0.00, '2019-09-19 22:41:29', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(6, 0.00, 0.00, 0.00, '2019-09-19 22:42:56', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(7, 0.00, 0.00, 0.00, '2019-09-19 22:42:56', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(8, 0.00, 0.00, 0.00, '2019-09-19 22:55:21', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(9, 0.00, 0.00, 0.00, '2019-09-19 23:01:10', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(10, 0.00, 0.00, 0.00, '2019-09-19 23:01:10', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(11, 0.00, 0.00, 0.00, '2019-09-19 23:15:45', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(12, 0.00, 0.00, 0.00, '2019-09-19 23:24:45', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(13, 0.00, 0.00, 0.00, '2019-09-19 23:24:45', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(14, 0.00, 0.00, 0.00, '2019-09-19 23:26:16', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(15, 0.00, 0.00, 0.00, '2019-09-19 23:27:35', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(16, 0.00, 0.00, 0.00, '2019-09-19 23:55:04', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(17, 0.00, 0.00, 0.00, '2019-09-20 00:13:22', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(18, 0.00, 0.00, 0.00, '2019-09-20 00:34:29', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(19, 0.00, 0.00, 0.00, '2019-09-20 00:34:29', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(20, 0.00, 0.00, 0.00, '2019-09-20 00:47:15', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(21, 0.00, 0.00, 0.00, '2019-09-20 00:47:15', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(22, 0.00, 0.00, 0.00, '2019-09-20 00:47:15', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(23, 0.00, 0.00, 0.00, '2019-09-20 00:47:15', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(24, 0.00, 0.00, 0.00, '2019-09-21 09:38:39', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(25, 0.00, 0.00, 0.00, '2019-09-21 09:44:21', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(26, 0.00, 0.00, 0.00, '2019-09-21 09:48:25', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(27, 0.00, 0.00, 0.00, '2019-09-21 09:48:25', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(28, 0.00, 0.00, 0.00, '2019-09-21 09:48:25', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(29, 0.00, 0.00, 0.00, '2019-09-21 09:48:25', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(30, 0.00, 0.00, 0.00, '2019-09-21 09:48:25', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(31, 0.00, 0.00, 0.00, '2019-09-21 09:48:25', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(32, 0.00, 0.00, 0.00, '2019-09-21 09:48:25', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(33, 0.00, 0.00, 0.00, '2019-09-21 09:48:25', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(34, 0.00, 0.00, 0.00, '2019-09-21 09:51:30', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(35, 0.00, 0.00, 0.00, '2019-09-21 09:56:47', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(36, 0.00, 0.00, 0.00, '2019-09-21 10:06:17', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(37, 0.00, 0.00, 0.00, '2019-09-21 10:08:31', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(38, 0.00, 0.00, 0.00, '2019-09-21 10:11:40', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(39, 0.00, 0.00, 0.00, '2019-09-21 10:11:40', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(40, 0.00, 0.00, 0.00, '2019-09-21 10:26:42', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(41, 0.00, 0.00, 0.00, '2019-09-21 10:28:38', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(42, 0.00, 0.00, 0.00, '2019-09-21 18:04:37', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(43, 0.00, 0.00, 0.00, '2019-09-23 11:05:26', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(44, 0.00, 0.00, 0.00, '2019-09-23 11:09:29', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(45, 0.00, 0.00, 0.00, '2019-09-23 15:59:47', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(46, 0.00, 0.00, 0.00, '2019-09-23 16:01:46', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(47, 0.00, 0.00, 0.00, '2019-09-23 16:16:33', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(48, 0.00, 0.00, 0.00, '2019-09-23 20:16:57', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(49, 0.00, 0.00, 0.00, '2019-09-23 23:25:31', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(50, 0.00, 0.00, 0.00, '2019-09-23 23:29:33', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(51, 0.00, 0.00, 0.00, '2019-09-23 20:39:15', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(52, 0.00, 0.00, 0.00, '2019-09-23 22:32:52', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(53, 0.00, 0.00, 0.00, '2019-09-24 15:28:52', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(54, 0.00, 0.00, 0.00, '2019-09-26 15:28:48', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(55, 0.00, 0.00, 0.00, '2019-09-26 16:04:27', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(56, 0.00, 0.00, 0.00, '2019-09-26 16:04:43', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(57, 0.00, 0.00, 0.00, '2019-09-26 16:07:15', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(58, 0.00, 0.00, 0.00, '2019-09-26 16:09:45', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(59, 0.00, 0.00, 0.00, '2019-09-26 16:10:11', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(60, 0.00, 0.00, 0.00, '2019-09-26 16:11:45', 2);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(61, 0.00, 0.00, 0.00, '0000-00-00 00:00:00', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(62, 0.00, 0.00, 0.00, '0000-00-00 00:00:00', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(63, 0.00, 0.00, 0.00, '0000-00-00 00:00:00', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(64, 0.00, 0.00, 0.00, '0000-00-00 00:00:00', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(65, 0.00, 0.00, 0.00, '2019-09-26 20:03:56', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(66, 0.00, 0.00, 0.00, '2019-09-26 20:05:15', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(68, 0.00, 0.00, 0.00, '2019-09-26 20:13:42', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(69, 0.00, 0.00, 0.00, '2019-09-26 20:14:42', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(70, 0.00, 0.00, 0.00, '2019-09-26 20:16:24', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(71, 0.00, 0.00, 0.00, '2019-09-26 20:28:12', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(72, 0.00, 0.00, 0.00, '2019-09-26 20:30:07', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(73, 0.00, 0.00, 0.00, '2019-09-26 20:36:45', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(74, 0.00, 0.00, 0.00, '2019-09-26 23:03:05', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(75, 0.00, 0.00, 0.00, '2019-09-26 23:07:29', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(76, 0.00, 0.00, 0.00, '2019-09-26 23:09:52', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(77, 0.00, 0.00, 0.00, '2019-09-26 23:20:02', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(78, 0.00, 0.00, 0.00, '2019-09-26 23:21:51', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(79, 0.00, 0.00, 0.00, '2019-09-26 23:34:09', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(80, 0.00, 0.00, 0.00, '2019-09-26 23:34:23', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(81, 0.00, 0.00, 0.00, '2019-09-26 23:35:33', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(82, 0.00, 0.00, 0.00, '2019-09-26 23:37:48', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(83, 0.00, 0.00, 0.00, '2019-09-26 23:39:23', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(84, 0.00, 0.00, 0.00, '2019-09-26 23:40:29', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(85, 0.00, 0.00, 0.00, '2019-09-26 23:41:42', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(86, 0.00, 0.00, 0.00, '2019-09-26 23:43:06', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(87, 0.00, 0.00, 0.00, '2019-09-26 23:46:07', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(88, 0.00, 0.00, 0.00, '2019-09-26 23:47:35', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(89, 0.00, 0.00, 0.00, '2019-09-26 23:50:17', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(90, 0.00, 0.00, 0.00, '2019-09-26 23:50:49', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(91, 0.00, 0.00, 0.00, '2019-09-27 00:59:24', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(92, 0.00, 0.00, 0.00, '2019-09-27 01:00:00', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(93, 0.00, 0.00, 0.00, '2019-09-27 01:06:17', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(94, 0.00, 0.00, 0.00, '2019-09-27 01:35:43', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(95, 0.00, 0.00, 0.00, '2019-09-27 09:28:19', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(96, 0.00, 0.00, 0.00, '2019-09-27 09:29:07', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(97, 0.00, 0.00, 0.00, '2019-09-27 09:30:30', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(98, 0.00, 0.00, 0.00, '2019-09-27 09:30:46', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(99, 0.00, 0.00, 0.00, '2019-09-27 10:21:38', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(100, 0.00, 0.00, 0.00, '2019-09-27 10:27:05', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(101, 0.00, 0.00, 0.00, '2019-09-27 10:44:23', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(102, 0.00, 0.00, 0.00, '2019-09-27 11:22:19', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(103, 0.00, 0.00, 0.00, '2019-09-28 16:12:47', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(104, 0.00, 0.00, 0.00, '2019-09-28 16:15:33', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(105, 0.00, 0.00, 0.00, '2019-09-28 16:18:03', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(106, 0.00, 0.00, 0.00, '2019-09-28 16:19:45', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(107, 0.00, 0.00, 0.00, '2019-09-29 13:59:29', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(108, 0.00, 0.00, 0.00, '2019-09-29 14:00:50', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(109, 0.00, 0.00, 0.00, '2019-09-29 14:58:20', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(110, 0.00, 0.00, 0.00, '2019-09-29 15:00:58', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(111, 0.00, 0.00, 0.00, '2019-09-29 15:02:45', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(112, 0.00, 0.00, 0.00, '2019-09-29 15:03:52', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(113, 0.00, 0.00, 0.00, '2019-09-29 15:05:28', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(114, 0.00, 0.00, 0.00, '2019-09-29 15:11:57', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(115, 0.00, 0.00, 0.00, '2019-09-29 15:12:42', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(116, 0.00, 0.00, 0.00, '2019-09-29 15:14:22', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(117, 0.00, 0.00, 0.00, '2019-09-29 15:16:11', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(118, 0.00, 0.00, 0.00, '2019-09-29 15:17:01', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(119, 0.00, 0.00, 0.00, '2019-09-29 15:17:54', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(120, 0.00, 0.00, 0.00, '2019-09-29 15:19:59', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(121, 0.00, 0.00, 0.00, '2019-09-29 15:35:17', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(122, 0.00, 0.00, 0.00, '2019-09-29 15:44:14', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(123, 0.00, 0.00, 0.00, '2019-09-29 15:47:13', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(124, 0.00, 0.00, 0.00, '2019-09-29 15:48:39', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(125, 0.00, 0.00, 0.00, '2019-09-29 15:50:01', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(126, 0.00, 0.00, 0.00, '2019-09-29 15:54:50', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(127, 0.00, 0.00, 0.00, '2019-09-30 11:45:14', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(128, 0.00, 0.00, 0.00, '2019-09-30 11:45:56', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(129, 0.00, 0.00, 0.00, '2019-09-30 12:01:54', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(130, 0.00, 0.00, 0.00, '2019-09-30 12:25:21', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(131, 0.00, 0.00, 0.00, '2019-09-30 12:27:18', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(132, 0.00, 0.00, 0.00, '2019-09-30 12:31:27', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(133, 0.00, 0.00, 0.00, '2019-09-30 12:33:57', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(134, 0.00, 0.00, 0.00, '2019-09-30 13:49:41', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(135, 1130.00, 0.00, 1130.00, '2019-09-30 21:12:22', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(140, 550.00, 0.00, 550.00, '2020-05-20 14:22:56', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(141, 950.00, 0.00, 950.00, '2020-05-22 09:10:37', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(142, 1150.00, 0.00, 1150.00, '2020-05-22 11:08:04', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(143, 330.00, 0.00, 330.00, '2020-05-22 11:17:35', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(144, 2050.00, 0.00, 2050.00, '2020-05-22 11:24:56', 3);
INSERT INTO sales (id_sales, sales_price, sales_discount, total, datesales, id_status) VALUES(145, 2850.00, 0.00, 2850.00, '2020-05-25 09:56:14', 3);


-- ----------------------------
-- Table structure for purchase
-- ----------------------------
CREATE TABLE purchase  (
  id_purchase int(11) NOT NULL AUTO_INCREMENT,
  datepurchase datetime(0) NULL DEFAULT NULL,
  total decimal(10, 2) NULL DEFAULT NULL,
  id_status int(11) NULL DEFAULT NULL,
  id_supplier int(255) NULL DEFAULT NULL,
  PRIMARY KEY (id_purchase),
  INDEX FK_entrada_cState(id_status),
  INDEX id_supplier(id_supplier),
  CONSTRAINT purchase_ibfk_1 FOREIGN KEY (id_supplier) REFERENCES supplier (id_supplier) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT purchase_ibfk_2 FOREIGN KEY (id_status) REFERENCES status (id_status) ON DELETE RESTRICT ON UPDATE RESTRICT
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of purchase
-- ----------------------------
INSERT INTO purchase VALUES (1, '2019-09-26 22:19:07', 0.00, 1, 3);
INSERT INTO purchase VALUES (2, '2019-09-26 22:21:30', 0.00, 1, 3);
INSERT INTO purchase VALUES (3, '2019-09-26 22:22:41', 0.00, 1, 3);
INSERT INTO purchase VALUES (4, '2019-09-26 22:29:26', 900.00, 1, 3);
INSERT INTO purchase VALUES (5, '2019-09-26 22:30:23', 8750.00, 1, 3);
INSERT INTO purchase VALUES (6, '2019-09-27 07:28:05', 7500.00, 1, 3);
INSERT INTO purchase VALUES (7, '2019-09-27 07:29:01', 17875.00, 1, 3);
INSERT INTO purchase VALUES (8, '2019-09-29 10:59:03', 1875.00, 1, 3);
INSERT INTO purchase VALUES (9, '2019-09-30 08:29:57', 300.00, 1, 3);
INSERT INTO purchase VALUES (10, '2019-09-30 10:47:55', 90.00, 1, 3);
INSERT INTO purchase VALUES (11, '2019-09-30 18:02:44', 100.00, 1, 3);
INSERT INTO purchase VALUES (12, '2019-09-30 18:07:19', 475.00, 1, 3);

-- ----------------------------
-- Table structure for purchase_detail
-- ----------------------------
CREATE TABLE purchase_detail  (
  id_purchase_detail int(11) NOT NULL AUTO_INCREMENT,
  id_purchase int(11) NULL DEFAULT NULL,
  unit_cost decimal(10, 0) NULL DEFAULT NULL,
  quantity int(11) NULL DEFAULT NULL,
  id_product int(11) NULL DEFAULT NULL,
  PRIMARY KEY (id_purchase_detail),
  INDEX FK_detail_entrada_product(id_product),
  INDEX FK_detail_entrada_entrada(id_purchase),
  CONSTRAINT purchase_detail_ibfk_1 FOREIGN KEY (id_purchase) REFERENCES purchase (id_purchase) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT purchase_detail_ibfk_2 FOREIGN KEY (id_product) REFERENCES product (id_product) ON DELETE RESTRICT ON UPDATE RESTRICT
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of purchase_detail
-- ----------------------------
INSERT INTO purchase_detail VALUES (3, 4, 90, 10, 1);
INSERT INTO purchase_detail VALUES (4, 5, 175, 50, 5);
INSERT INTO purchase_detail VALUES (5, 6, 750, 10, 2);
INSERT INTO purchase_detail VALUES (6, 7, 750, 20, 5);
INSERT INTO purchase_detail VALUES (7, 7, 100, 10, 4);
INSERT INTO purchase_detail VALUES (8, 7, 125, 15, 5);
INSERT INTO purchase_detail VALUES (9, 8, 75, 25, 4);
INSERT INTO purchase_detail VALUES (10, 9, 150, 2, 8);
INSERT INTO purchase_detail VALUES (12, 10, 90, 1, 4);
INSERT INTO purchase_detail VALUES (13, 11, 50, 2, 4);
INSERT INTO purchase_detail VALUES (14, 12, 95, 5, 1);

-- ----------------------------
-- Table structure for loss_detail
-- ----------------------------
CREATE TABLE loss_detail  (
  id_loss_detail int(11) NOT NULL AUTO_INCREMENT,
  id_loss int(11) NULL DEFAULT NULL,
  unit_cost decimal(10, 2) NULL DEFAULT NULL,
  id_product int(11) NULL DEFAULT NULL,
  quantity int(11) NULL DEFAULT NULL,
  PRIMARY KEY (id_loss_detail),
  INDEX FK_loss_detail_loss(id_product),
  INDEX FK_loss_detail_loss1(id_loss),
  CONSTRAINT loss_detail_ibfk_1 FOREIGN KEY (id_product) REFERENCES product (id_product) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT loss_detail_ibfk_2 FOREIGN KEY (id_loss) REFERENCES loss (id_loss) ON DELETE RESTRICT ON UPDATE RESTRICT
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE sales_detail (
  id_sales_detail int(11) NOT NULL AUTO_INCREMENT,
  id_sales int(11) DEFAULT NULL,
  unit_cost decimal(10,2) DEFAULT NULL,
  unit_value decimal(10,2) DEFAULT NULL,
  quantity int(11) DEFAULT NULL,
  discount decimal(10,2) DEFAULT '0.00',
  item_total decimal(10,2) DEFAULT '0.00',
  id_product int(11) DEFAULT NULL,
  PRIMARY KEY (id_sales_detail),
  CONSTRAINT sales_detail_ibfk_1 FOREIGN KEY (id_sales) REFERENCES sales (id_sales) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT sales_detail_id_productfk_1 FOREIGN KEY (id_product) REFERENCES product (id_product) ON DELETE RESTRICT ON UPDATE RESTRICT
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;


INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(1, 7, 75.00, 125.00, 12, 0.00, 1500.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(2, 7, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(3, 7, 800.00, 950.00, 10, 0.00, 9500.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(4, 7, 425.00, 550.00, 20, 0.00, 11000.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(8, 7, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(9, 8, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(10, 8, 90.00, 125.00, 2, 0.00, 250.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(15, 12, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(16, 14, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(17, 15, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(18, 15, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(19, 15, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(20, 15, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(21, 15, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(22, 15, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(23, 15, 90.00, 125.00, 2, 0.00, 250.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(24, 15, 165.00, 205.00, 1, 0.00, 205.00, 7);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(25, 15, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(26, 15, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(27, 15, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(28, 16, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(29, 16, 165.00, 205.00, 1, 0.00, 205.00, 7);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(30, 16, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(31, 16, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(32, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(33, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(34, 17, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(35, 17, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(36, 17, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(37, 17, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(38, 17, 90.00, 125.00, 2, 0.00, 250.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(39, 17, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(40, 17, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(41, 17, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(42, 17, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(43, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(44, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(45, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(46, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(47, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(48, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(49, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(50, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(51, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(52, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(53, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(54, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(55, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(56, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(57, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(58, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(59, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(60, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(61, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(62, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(63, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(64, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(65, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(66, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(67, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(68, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(69, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(70, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(71, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(72, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(73, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(74, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(75, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(76, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(77, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(78, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(79, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(80, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(81, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(82, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(83, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(84, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(85, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(86, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(87, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(88, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(89, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(90, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(91, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(92, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(93, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(94, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(95, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(96, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(97, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(98, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(99, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(100, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(101, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(102, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(103, 17, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(104, 17, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(105, 17, 90.00, 125.00, 2, 0.00, 250.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(106, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(107, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(108, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(109, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(110, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(111, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(112, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(113, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(114, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(115, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(116, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(117, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(118, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(119, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(120, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(121, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(122, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(123, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(124, 17, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(125, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(126, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(127, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(128, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(129, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(130, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(131, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(132, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(133, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(134, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(135, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(136, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(137, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(138, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(139, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(140, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(141, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(142, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(143, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(144, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(145, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(146, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(147, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(148, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(149, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(150, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(151, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(152, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(153, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(154, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(155, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(156, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(157, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(158, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(159, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(160, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(161, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(162, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(163, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(164, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(165, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(166, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(167, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(168, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(169, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(170, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(171, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(172, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(173, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(174, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(175, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(176, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(177, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(178, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(179, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(180, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(181, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(182, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(183, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(184, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(185, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(186, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(187, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(188, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(189, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(190, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(191, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(192, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(193, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(194, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(195, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(196, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(197, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(198, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(199, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(200, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(201, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(202, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(203, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(204, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(205, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(206, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(207, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(208, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(209, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(210, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(211, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(212, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(213, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(214, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(215, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(216, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(217, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(218, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(219, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(220, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(221, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(222, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(223, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(224, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(225, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(226, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(227, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(228, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(229, 18, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(230, 19, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(231, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(232, 19, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(233, 19, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(234, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(235, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(236, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(237, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(238, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(239, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(240, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(241, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(242, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(243, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(244, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(245, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(246, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(247, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(248, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(249, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(250, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(251, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(252, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(253, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(254, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(255, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(256, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(257, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(258, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(259, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(260, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(261, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(262, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(263, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(264, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(265, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(266, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(267, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(268, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(269, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(270, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(271, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(272, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(273, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(274, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(275, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(276, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(277, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(278, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(279, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(280, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(281, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(282, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(283, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(284, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(285, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(286, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(287, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(288, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(289, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(290, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(291, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(292, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(293, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(294, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(295, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(296, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(297, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(298, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(299, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(300, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(301, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(302, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(303, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(304, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(305, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(306, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(307, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(308, 19, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(309, 20, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(310, 22, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(311, 22, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(312, 22, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(313, 23, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(314, 23, 200.00, 285.00, 1, 0.00, 285.00, 6);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(315, 23, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(316, 23, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(317, 23, 200.00, 285.00, 1, 0.00, 285.00, 6);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(318, 24, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(319, 24, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(320, 34, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(321, 34, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(322, 35, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(323, 36, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(324, 36, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(325, 36, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(326, 37, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(327, 37, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(328, 37, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(329, 38, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(330, 38, 75.00, 125.00, 10, 0.00, 1250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(331, 38, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(332, 39, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(333, 39, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(334, 39, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(335, 39, 90.00, 125.00, 2, 0.00, 250.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(336, 39, 75.00, 125.00, 10, 0.00, 1250.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(337, 40, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(338, 40, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(339, 40, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(341, 41, 75.00, 125.00, 12, 0.00, 1500.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(342, 41, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(343, 41, 800.00, 950.00, 12, 0.00, 11400.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(344, 42, 425.00, 550.00, 23, 0.00, 12650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(345, 42, 90.00, 125.00, 11, 0.00, 1375.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(351, 42, 200.00, 285.00, 1, 0.00, 285.00, 6);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(361, 7, 165.00, 205.00, 2, 0.00, 410.00, 7);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(429, 6, 10.00, 15.00, 7, 0.00, 105.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(431, 6, 10.00, 15.00, 7, 0.00, 105.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(432, 6, 10.00, 15.00, 7, 0.00, 105.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(433, 6, 10.00, 15.00, 7, 0.00, 105.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(434, 6, 10.00, 15.00, 7, 0.00, 105.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(435, 46, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(436, 47, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(437, 47, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(456, 10, 425.00, 550.00, 19, 0.00, 10450.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(472, 10, 90.00, 125.00, 3, 0.00, 375.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(477, 10, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(478, 10, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(479, 48, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(480, 48, 425.00, 550.00, 21, 0.00, 11550.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(481, 48, 800.00, 950.00, 10, 0.00, 9500.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(483, 48, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(484, 48, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(485, 49, 425.00, 550.00, 19, 0.00, 10450.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(486, 50, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(487, 48, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(488, 51, 425.00, 550.00, 18, 0.00, 9900.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(489, 51, 800.00, 950.00, 7, 0.00, 6650.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(490, 51, 750.00, 1025.00, 24, 0.00, 24600.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(501, 52, 425.00, 550.00, 16, 0.00, 8800.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(502, 52, 75.00, 125.00, 7, 0.00, 875.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(505, 52, 75.00, 125.00, 5, 0.00, 625.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(506, 52, 200.00, 285.00, 1, 0.00, 285.00, 6);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(507, 53, 425.00, 550.00, 16, 0.00, 8800.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(508, 53, 75.00, 125.00, 7, 0.00, 875.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(509, 53, 800.00, 950.00, 8, 0.00, 7600.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(510, 53, 75.00, 125.00, 3, 0.00, 375.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(511, 53, 750.00, 1025.00, 7, 0.00, 7175.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(512, 54, 75.00, 125.00, 8, 0.00, 1000.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(513, 55, 425.00, 550.00, 16, 0.00, 8800.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(514, 55, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(515, 55, 75.00, 125.00, 3, 0.00, 375.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(516, 57, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(517, 57, 425.00, 550.00, 12, 0.00, 6600.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(520, 60, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(521, 60, 75.00, 125.00, 3, 0.00, 375.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(522, 60, 425.00, 550.00, 12, 0.00, 6600.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(523, 60, 800.00, 950.00, 5, 0.00, 4750.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(524, 63, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(525, 63, 425.00, 550.00, 12, 0.00, 6600.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(526, 63, 75.00, 125.00, 3, 0.00, 375.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(527, 64, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(528, 64, 75.00, 125.00, 2, 0.00, 250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(529, 64, 425.00, 550.00, 12, 0.00, 6600.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(536, 69, 200.00, 285.00, 1, 0.00, 285.00, 6);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(537, 69, 165.00, 205.00, 1, 0.00, 205.00, 7);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(538, 69, 800.00, 950.00, 4, 0.00, 3800.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(539, 69, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(540, 69, 750.00, 1025.00, 1, 0.00, 1025.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(541, 71, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(542, 71, 425.00, 550.00, 12, 0.00, 6600.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(544, 74, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(547, 74, 75.00, 125.00, 2, 0.00, 250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(548, 75, 90.00, 125.00, 2, 0.00, 250.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(549, 75, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(551, 76, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(554, 77, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(555, 77, 800.00, 950.00, 2, 0.00, 1900.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(556, 78, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(557, 78, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(558, 80, 35.00, 50.00, 3, 0.00, 150.00, 10);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(559, 80, 75.00, 125.00, 2, 0.00, 250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(560, 80, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(561, 81, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(562, 81, 35.00, 50.00, 3, 0.00, 150.00, 10);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(563, 81, 75.00, 125.00, 2, 0.00, 250.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(564, 82, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(565, 82, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(566, 82, 750.00, 1025.00, 1, 0.00, 1025.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(567, 83, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(568, 83, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(569, 84, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(570, 84, 800.00, 950.00, 2, 0.00, 1900.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(571, 85, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(572, 86, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(573, 86, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(574, 87, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(575, 87, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(576, 88, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(577, 89, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(578, 90, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(579, 90, 800.00, 950.00, 2, 0.00, 1900.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(580, 91, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(581, 93, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(583, 94, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(584, 94, 425.00, 550.00, 9, 0.00, 4950.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(585, 94, 35.00, 50.00, 3, 0.00, 150.00, 10);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(586, 95, 750.00, 1025.00, 1, 0.00, 1025.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(587, 95, 800.00, 950.00, 2, 0.00, 1900.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(588, 95, 35.00, 50.00, 3, 0.00, 150.00, 10);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(589, 99, 200.00, 285.00, 1, 0.00, 285.00, 6);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(591, 99, 75.00, 125.00, 1, 0.00, 125.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(592, 99, 425.00, 550.00, 6, 0.00, 3300.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(593, 100, 800.00, 950.00, 2, 0.00, 1900.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(595, 100, 90.00, 125.00, 1, 0.00, 125.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(598, 100, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(599, 101, 75.00, 125.00, 5, 0.00, 625.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(600, 101, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(601, 101, 800.00, 950.00, 2, 0.00, 1900.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(602, 102, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(603, 102, 75.00, 125.00, 1, 0.00, 125.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(605, 102, 35.00, 50.00, 5, 0.00, 250.00, 10);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(606, 103, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(607, 103, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(608, 103, 75.00, 125.00, 1, 0.00, 125.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(610, 104, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(611, 104, 75.00, 125.00, 1, 0.00, 125.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(612, 105, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(613, 105, 75.00, 125.00, 1, 0.00, 125.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(614, 106, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(615, 106, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(616, 106, 90.00, 125.00, 1, 0.00, 125.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(617, 108, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(618, 108, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(619, 108, 750.00, 1025.00, 1, 0.00, 1025.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(620, 109, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(621, 110, 75.00, 125.00, 1, 0.00, 125.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(622, 111, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(623, 111, 75.00, 125.00, 1, 0.00, 125.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(624, 112, 90.00, 125.00, 1, 0.00, 125.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(625, 113, 90.00, 125.00, 1, 0.00, 125.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(626, 113, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(627, 76, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(629, 114, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(630, 114, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(631, 116, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(632, 117, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(633, 118, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(634, 119, 200.00, 285.00, 1, 0.00, 285.00, 6);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(635, 120, 75.00, 125.00, 1, 0.00, 125.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(636, 121, 800.00, 950.00, 4, 0.00, 3800.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(637, 121, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(638, 122, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(639, 122, 750.00, 1025.00, 1, 0.00, 1025.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(640, 123, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(641, 123, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(642, 124, 75.00, 125.00, 1, 0.00, 125.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(643, 124, 75.00, 125.00, 1, 0.00, 125.00, 5);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(644, 125, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(645, 126, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(646, 126, 750.00, 1025.00, 1, 0.00, 1025.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(647, 128, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(648, 128, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(649, 128, 35.00, 50.00, 3, 0.00, 150.00, 10);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(650, 130, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(651, 130, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(652, 130, 35.00, 50.00, 3, 0.00, 150.00, 10);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(653, 131, 165.00, 205.00, 1, 0.00, 205.00, 7);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(654, 131, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(655, 131, 425.00, 550.00, 3, 0.00, 1650.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(656, 132, 35.00, 50.00, 5, 0.00, 250.00, 10);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(657, 132, 165.00, 205.00, 1, 0.00, 205.00, 7);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(658, 134, 75.00, 125.00, 1, 0.00, 125.00, 4);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(660, 134, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(667, 135, 90.00, 125.00, 3, 0.00, 375.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(669, 135, 425.00, 550.00, 1, 0.00, 550.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(672, 135, 165.00, 205.00, 1, 0.00, 205.00, 7);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(673, 140, 425.00, 550.00, 1, 0.00, 550.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(674, 141, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(675, 142, 750.00, 1025.00, 1, 0.00, 1025.00, 8);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(676, 142, 90.00, 125.00, 1, 0.00, 125.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(678, 143, 165.00, 205.00, 1, 0.00, 205.00, 7);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(679, 143, 90.00, 125.00, 1, 0.00, 125.00, 1);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(680, 144, 800.00, 950.00, 1, 0.00, 950.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(681, 144, 425.00, 550.00, 2, 0.00, 1100.00, 3);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(682, 145, 800.00, 950.00, 2, 0.00, 1900.00, 2);
INSERT INTO sales_detail (id_sales_detail, id_sales, unit_cost, unit_value, quantity, discount, item_total, id_product) VALUES(683, 145, 800.00, 950.00, 1, 0.00, 950.00, 2);

-- ----------------------------
-- View structure for vdetailsales
-- ----------------------------
CREATE VIEW vdetailsales AS select product_name AS name,sales_detail.unit_value AS unit_value,sales_detail.quantity AS quantity,sales_detail.id_sales AS id_sales from (sales_detail join product on(sales_detail.id_product = product.id_product));