var arr_placeholder = {
	id: '',
	text: '',
	hint: '',
	app: '',
	icon: '',
	icon_check: 'S',
	type_item: 'L',
	display: 'N',
	link_target: 'self',
	fav_check: 'N',
	mega_check: 'N',
	children: []
};
var processing = false;
var stop_poll = false;
var debug = false;

var notif_fields = [
	'notif_table',
	'notif_id',
	'notif_title',
	'notif_message',
	'notif_dtexpire',
	'notif_login_sender',
	'notif_categ',
	'notif_type',
	'notif_link',
	'inbox_table',
	'inbox_field_notif_id',
	'inbox_field_ontop',
	'inbox_field_userid',
	'inbox_field_isread',
	'inbox_field_read_date',
	'inbox_field_sent_date',
	'inbox_field_tag',
	'inbox_field_important',
	'user_table',
	'user_login',
	'user_fullname',
	'user_image',
];
function pickFont(font_name) {
	if (font_name == '') {
		$('#enable_font_string').show();
	} else {
		$('#enable_font_string').hide();
	}
	$('#font_string').val(font_name);
	updateValueArr(true);
}
function startFontAwesomeField(str_input_id, treeName) {
	debugmessage('startFontAwesomeField');
	if(!$('#'+str_input_id).hasClass('iconpicker-input')) {
		$('#'+str_input_id).iconpicker({hideOnSelect: true, placement: 'top'}).on('iconpickerSelected', function(e){
			editItem(treeName, true);
			updateIconPreview($('#'+str_input_id).val(), treeName);
		}).on('iconpickerShown', function(e){ $('.iconpicker-search').focus(); });
		$('#'+str_input_id).focus();
	}
}
function updateIconPreview(iconVal, treeName) {
	debugmessage('updateIconPreview');
	$('#icon-' + treeName + '-preview').attr('class', iconVal);
}
function updateValueArr(modif) {
	debugmessage('updateValueArr');
	if (!stop_poll) {
		updateFavSort();
		arr_val.items = treeItens.toArray();
		arr_val.user_items = treeUser.toArray();
		arr_val.tb_items = treeTB.toArray();
		arr_val.usercheck = $('#user_check_enable').val();
		arr_val.username = $('#user_name_var').val();
		arr_val.userimage = $('#user_img_var').val();
		arr_val.userdesc = $('#user_desc_var').val();
		arr_val.theme = $('#theme_list').val();
		arr_val.pick_themes = $('#themes_pick').val();
		arr_val.layout = $('#layout_list').val();
		arr_val.layout_usr_pos = $('#layout_usr_pos').val();
		arr_val.logo = $('#full_logo').val();
		arr_val.logo_compact = $('#small_logo').val();
		arr_val.header_string = $('#header_string').val();
		arr_val.header_string_pos = $('#header_string_pos').val();
		arr_val.font_string = $('#font_string').val();

		if ($('#check_toolbar').is(':checked')) {
			arr_val.check_toolbar = 'S';
		} else {
			arr_val.check_toolbar = 'N';
		}
		if ($('#check_split').is(':checked')) {
			arr_val.check_split = 'S';
		} else {
			arr_val.check_split = 'N';
		}
		if ($('#check_show_search_path').is(':checked')) {
			arr_val.check_show_search_path = 'S';
		} else {
			arr_val.check_show_search_path = 'N';
		}
		if ($('#check_use_loader').is(':checked')) {
			arr_val.check_use_loader = 'S';
		} else {
			arr_val.check_use_loader = 'N';
		}
		if ($('#check_shortcut_label').is(':checked')) {
			arr_val.check_shortcut_label = 'S';
		} else {
			arr_val.check_shortcut_label = 'N';
		}
		if ($('#check_start_expanded').is(':checked')) {
			arr_val.check_start_expanded = 'S';
		} else {
			arr_val.check_start_expanded = 'N';
		}
		if ($('#should_reload').is(':checked')) {
			arr_val.should_reload = 'S';
		} else {
			arr_val.should_reload = 'N';
		}

		arr_val['notif_login_var'] = $('#item_notif_login_var').val();
		arr_val['notif_open_all_app'] = $('#item_notif_open_all_app').val();
		arr_val['notif_refresh_interval'] = $('#item_notif_refresh_interval').val();
		arr_val['notif_limit'] = $('#item_notif_limit').val();
		arr_val['notif_data']['notif_connection'] = $('#item_notif_connection').val();
		notif_fields.forEach(function (i) {
			var item_data_val = $('#item_' + i).val();
			if (typeof item_data_val === "string" && item_data_val.length > 0) {
				arr_val['notif_data'][i] = item_data_val;
			}
		});


		updateValField(false);
		if (modif) {
			nm_form_modified();
		}
	}
}
function updateNotifConnection(conn_val) {
	processing = true;
	notif_fields.forEach(function (i) {
		var select_field = $('#item_' + i);
		select_field.find('option').remove();
		select_field.attr('disabled', 'disabled');
		select_field.closest('.ui.dropdown').addClass('disabled');
		select_field.closest('.ui.dropdown').addClass('loading');
	});
	var req_data = {conn: conn_val};

	$.ajax({
		type: "POST",
		dataType: "json",
		url: '../iface/ajax_function.php',
		data: {
			call: 'getTables',
			data: req_data
		},
		complete: function (a, b) {
			notif_fields.forEach(function (i) {
				var select_field = $('#item_' + i);
				var resp_data = JSON.parse(a.responseText);
				if (!select_field.is('[data-updated-from]')) {
					for (var [key, value] of Object.entries(resp_data.data.arr_tables)) {
						var selected_prop = '';
						if ( key.split('.')[key.split('.').length -1].toLowerCase() == arr_val['notif_data'][i].toLowerCase() ) {
							selected_prop = 'selected="selected"';
							arr_val['notif_data'][i] = key;
						}
						select_field.append('<option value="' + key + '" ' + selected_prop + '>' + key + '</option>');
					}
					select_field.removeAttr('disabled');
					select_field.val(arr_val['notif_data'][i]);
					select_field.closest('.ui.dropdown').removeClass('disabled');
					select_field.closest('.ui.dropdown').removeClass('loading');
					select_field.dropdown('change values');
					select_field.dropdown('refresh');
					// setTimeout( function () {
					// 	select_field.dropdown('setting', 'onRefresh',
					// 		function () {
					// 			select_field.dropdown('set selected', arr_val['notif_data'][i]);
					// 		}
					// 	);
					// 	select_field.dropdown();
					// }, 10);

				}
			});
			var tables_to_update = [];
			setTimeout( function () {
				var should_upd = false;
				notif_fields.forEach(function (i) {
					var select_field = $('#item_' + i);
					if (!select_field.is('[data-updated-from]')) {
						select_field.dropdown('set selected', arr_val['notif_data'][i]);
						if (select_field.val() == arr_val['notif_data'][i]) {
							var should_upd = true;
							tables_to_update.push(select_field[0]);
						}
					}
				});
				if (should_upd) {
					updateValueArr(true);
				}
			}, 20);
			processing = false;

			updateNotifTable(tables_to_update);
		},
		dataType: 'text'
	});
}
function updateNotifTable(tb_fields) {
	if (processing) return false;
	processing = true;
	if (!Array.isArray(tb_fields)) {
		tb_fields = [tb_fields];
	}
	var should_upd = false;
	tb_fields.forEach(function (tb_field) {
		var tb_name = tb_field;
		var tb_val = $('#item_' + tb_field).val();
		var conn_val = $('#item_notif_connection').val();
		var req_data = {conn: conn_val, table_usr: tb_val};
		notif_fields.forEach(function (i) {
			var select_field = $('#item_' + i);
			if (select_field.is('[data-updated-from='+tb_name+']')) {
				select_field.find('option').remove();
				select_field.attr('disabled', 'disabled');
				select_field.closest('.ui.dropdown').addClass('disabled');
				select_field.closest('.ui.dropdown').addClass('loading');
			}
		});

		$.ajax({
			type: "POST",
			dataType: "json",
			url: '../iface/ajax_function.php',
			data: {
				call: 'getFields',
				data: req_data
			},
			complete: function (a, b) {
				notif_fields.forEach(function (i) {
					var select_field = $('#item_' + i);
					var resp_data = JSON.parse(a.responseText);
					if (select_field.is('[data-updated-from='+tb_name+']')) {
						select_field.append(resp_data.data.options_html);
						select_field.removeAttr('disabled');
						select_field.closest('.ui.dropdown').removeClass('disabled');
						select_field.closest('.ui.dropdown').removeClass('loading');
						select_field.dropdown('change values');
						select_field.dropdown('refresh');
					}
				});

				setTimeout( function () {
					notif_fields.forEach(function (i) {
						var select_field = $('#item_' + i);
						if (select_field.is('[data-updated-from='+tb_name+']')) {
							select_field.dropdown('set selected', arr_val['notif_data'][i]);
							if (select_field.val() == arr_val['notif_data'][i]) {
								should_upd = true;
							} else {
								select_field.dropdown('set selected', arr_val['notif_data'][i].toUpperCase());
								if (select_field.val() == arr_val['notif_data'][i]) {
									should_upd = true;
								}
							}
						}
					});
				}, 20);
			},
			dataType: 'text'
		});
	});
	if (should_upd) {
		updateValueArr(true);
	}
	processing = false;
}
function updateValField(modif) {
	debugmessage('updateValField');
	$('#navmenu_itens').val(JSON.stringify(arr_val));
	if (modif && !stop_poll) {
		nm_form_modified();
	}
}
function setImageFromPicker(a,b,c) {
	debugmessage('setImageFromPicker');
	updateValueArr(true);
}
function loadImagePicker(e) {
	debugmessage('loadImagePicker');
	var el_name = $(e.target).closest('.field').find('input').attr('name');
	e.preventDefault();

	nm_window_image_new('menu_img','form_edit', el_name, 'setImageFromPicker');
}
function updateToolbarType() {
	debugmessage('updateToolbarType');
	var type_sel = $('#tb_item_type').val();
	if (type_sel) {
		$('.type_tb_item').hide();
		$('.type_tb_item.type_'+type_sel).show();
	}

}
function getNextId(workingTree) {
	debugmessage('getNextId');
	var biggest = 1;
	var treeName = getTreeName(workingTree);
	var tree_id_name = '_' + treeName;
	if (treeName == 'menu') {
		tree_id_name = '';
	}
	var ret_id = 'item' + tree_id_name + '_1';
	workingTree.flatten(function(){return true;}).each(function (node) {
		var data = node.toObject();
		var id = data.id;
		if (id.indexOf('item' + tree_id_name + '_') !== -1) {
			var next_num = parseInt(id.replace('item' + tree_id_name + '_', '')) || 1;
			if (next_num >= biggest) {
				biggest = next_num;
				ret_id = 'item' + tree_id_name + '_' + (next_num + 1);
			}
		}
	});
	return ret_id;
}
function getTreeName(tree) {
	debugmessage('getTreeName');
	var ret_val = 'menu';
	if (tree == treeItens) {
		ret_val = 'menu';
	} else if (tree == treeUser) {
		ret_val = 'user';
	} else if (tree == treeTB) {
		ret_val = 'tb';
	}
	return ret_val;
}
function getDomByTree(tree) {
	debugmessage('getDomByTree');
	var ret_val = 'menu';
	if (tree == treeItens) {
		ret_val = treeItemsDom;
	} else if (tree == treeUser) {
		ret_val = treeUserDom;
	} else if (tree == treeTB) {
		ret_val = treeTBDom;
	}
	return ret_val;
}
function getTreeById(s_item_data) {
	debugmessage('getTreeById');
	var itemId = s_item_data.id;
	if ($('.menu_list li[data-uid="' + itemId + '"]').length > 0) {
		return 'menu'
	} else if ($('.user_list li[data-uid="' + itemId + '"]').length > 0) {
		return 'user'
	} else if ($('.tb_list li[data-uid="' + itemId + '"]').length > 0) {
		return 'tb'
	} else {
		return 'menu';
	}
}
function checkMegaMessage(s_item_data, node_data, edit_trigger) {
	var treeName = getTreeById(s_item_data);
	var data = node_data.toObject();
	var data_c = node_data.getTextualHierarchy();
	var data_p = node_data.getParents();
	var edited = (typeof edit_trigger != 'undefined') ? edit_trigger : false;

	if (edited && (!data.children || data.children.length == 0)) {
		$('#item_' + treeName + '_hint').attr('disabled', false);
		$('#item_' + treeName + '_link').attr('disabled', false);
		$('#item_' + treeName + '_link + button').attr('disabled', false);
		$('#item_' + treeName + '_target').closest('.ui.dropdown').removeClass('disabled');
		$('#item_' + treeName + '_check_fav').attr('disabled', false);
	}
	$('#not_shown_message').removeClass('visible');
	if (data_p[data_p.length -1]) {
		var rootNode = data_p[data_p.length -1].toObject();
		if (rootNode.mega_check == 'S' && data_c.length > 2 && data.children && data.children.length > 0) {
			$('#not_shown_message').addClass('visible');
		}
		if (rootNode.mega_check == 'S' && data_c.length == 2) {
			$('#item_' + treeName + '_hint').attr('disabled', true);
			$('#item_' + treeName + '_link').attr('disabled', true);
			$('#item_' + treeName + '_link + button').attr('disabled', true);
			$('#item_' + treeName + '_target').closest('.ui.dropdown').addClass('disabled');
			$('#item_' + treeName + '_check_fav').attr('disabled', true);
		}
	} else if (data.mega_check == 'S') {

		$('#item_' + treeName + '_hint').attr('disabled', true);
		$('#item_' + treeName + '_link').attr('disabled', true);
		$('#item_' + treeName + '_link + button').attr('disabled', true);
		$('#item_' + treeName + '_target').closest('.ui.dropdown').addClass('disabled');
		$('#item_' + treeName + '_check_fav').attr('disabled', true);
	}

}
function loadItem(s_item_data, node_data) {
	debugmessage('loadItem');
	stop_poll = true;
	var treeName = getTreeById(s_item_data);
	var tree_id_name = '_' + treeName;
	if (treeName == 'menu') {
		tree_id_name = '';
	}
	// $('.item_content').removeClass('selected_item');
	// $('#' + id).find('> .item_content').addClass('selected_item');
	$('#icon-' + treeName + '-preview').removeClass();
	$('#icon-' + treeName + '-preview').addClass(s_item_data.icon);
	$('#item_' + treeName + '_icon').attr('disabled', false).val(s_item_data.icon);
	$('#item_' + treeName + '_name').attr('disabled', false).val(s_item_data.text);
	$('#item_' + treeName + '_hint').attr('disabled', false).val(s_item_data.hint);
	$('#item_' + treeName + '_link').attr('disabled', false).val(s_item_data.app);
	$('#item_' + treeName + '_link + button').attr('disabled', false);
	$('#item_' + treeName + '_id').val(s_item_data.id);
	$('#item_' + treeName + '_id_show').val(s_item_data.id);
	if (s_item_data.icon_check == 'S') {
		$('#item_' + treeName + '_check_icon').attr('disabled', false).prop('checked', true);
	} else {
		$('#item_' + treeName + '_check_icon').attr('disabled', false).prop('checked', false);
	}
	if (s_item_data.mega_check == 'S') {
		$('#item_' + treeName + '_check_mega').prop('checked', true);
	} else {
		$('#item_' + treeName + '_check_mega').prop('checked', false);
	}
	if (node_data.getTextualHierarchy().length == 1) {
		$('#item_' + treeName + '_check_mega').attr('disabled', false);
	} else {
		$('#item_' + treeName + '_check_mega').attr('disabled', true);
	}
	if (arr_val.shortcuts.includes(s_item_data.id)) {
		$('#item_' + treeName + '_check_fav').attr('disabled', false).prop('checked', true);
	} else {
		$('#item_' + treeName + '_check_fav').attr('disabled', false).prop('checked', false);
	}

	if(treeName == 'tb')
	{
		if (s_item_data.display == 'S') {
			$('#item_' + treeName + '_display').attr('disabled', false).prop('checked', true);
		} else {
			$('#item_' + treeName + '_display').attr('disabled', false).prop('checked', false);
		}
		$('.tb_field').hide();
		$('.tb_field_' + s_item_data.app).show();
	}

	$('#item_' + treeName + '_target').closest('.ui.dropdown').removeClass('disabled');
	if (['blank', 'self', 'parente'].indexOf(s_item_data.link_target) != -1) {
		$('#item_' + treeName + '_target').val(s_item_data.link_target);
	} else {
		$('#item_' + treeName + '_target').val('self');
	}
	$('#item_' + treeName + '_target').change();
	if (s_item_data.children && s_item_data.children.length > 0) {
		$('#item_' + treeName + '_check_fav').attr('disabled', true);
		$('#item_' + treeName + '_hint').attr('disabled', true);
		$('#item_' + treeName + '_target').closest('.ui.dropdown').addClass('disabled');
		$('#item_' + treeName + '_link').attr('disabled', true);
		$('#item_' + treeName + '_link + button').attr('disabled', true);
	}

	$('#form_' + treeName).css('opacity', 1);
	checkMegaMessage(s_item_data, node_data);
	checkedIcon();
	stop_poll = false;
}
function getNodeDom(id) {
	return $('.inspire-tree li[data-uid="' + id + '"]');
}
function getNodeDomA(id) {
	return $('.inspire-tree a[data-uid="' + id + '"]');
}
function updateTreeIcons(tree) {
	debugmessage('updateTreeIcons');
	// [treeItens, treeUser, treeTB].forEach(function (tree) {
		tree.flatten(function(){return true;}).each(function (node) {
			var data = node.toObject();
			var data_c = node.getTextualHierarchy();
			var data_p = node.getParents();
			// console.log(data_c.length);
			// console.log(data_p[data_p.length -1]);
			var node_dom = $('.inspire-tree .title-wrap .title.icon[data-uid="' + data.id + '"]');
			var icon_place = 'fa fa-bw';
			if (data.icon_check == 'S') {
				icon_place = data.icon;
			}
			node_dom.find('i.tree_icon_pos').remove();
			node_dom.prepend('<i class="tree_icon_pos ' + icon_place + '"></i>');
			node_dom.css({backgroundColor: ''});

			node_dom.find('span.mega_indicator').remove();
			if (data.mega_check == 'S' && data_c.length == 1) {
				// node_dom.append('<span class="mega_indicator"> <i class="fa-solid fa-ellipsis-vertical"></i> </span>');
				node_dom.append('<span class="mega_indicator mega_root"> MEGAMENU </span>');
				// node_dom.css({backgroundColor: 'red'});
			}

			node_dom.css({opacity: ''});
			if (data_p[data_p.length -1]) {
				var rootNode = data_p[data_p.length -1].toObject();
				if (data.text == '{lang_list_apps}') {
					console.log(rootNode.mega_check)
					console.log(data_c.length)
					console.log(node_dom.children.length)
				}
				if (rootNode.mega_check == 'S' && data_c.length > 2 && data.children && data.children.length > 0) {
					node_dom.css({opacity: '.3'});
				}
				if (rootNode.mega_check == 'S' && data_c.length == 2) {
					node_dom.append('<span class="mega_indicator mega_column"> COLUMN </span>');
				}
			}
		});
	// });
}
function moveItem(where) {
	debugmessage($('.item_content > .item_checkbox input:checked'));
}
function getTreeByName(treeName) {
	debugmessage('getTreeByName');
	var opts = {
		'menu': treeItens,
		'user': treeUser,
		'tb': treeTB,
	}
	return opts[treeName];
}
function lockEditor(treeName) {
	debugmessage('lockEditor');

	$('#icon-' + treeName + '-preview').removeClass();
	$('#icon-' + treeName + '-preview').addClass('');
	$('#item_' + treeName + '_icon').attr('disabled', true).val('');
	$('#item_' + treeName + '_name').attr('disabled', true).val('');
	$('#item_' + treeName + '_hint').attr('disabled', true).val('');
	$('#item_' + treeName + '_link').attr('disabled', true).val('');
	$('#item_' + treeName + '_target').closest('.ui.dropdown').addClass('disabled');
	$('#item_' + treeName + '_target').val('');
	$('#item_' + treeName + '_link + button').attr('disabled', true);
	$('#item_' + treeName + '_id').val('');
	$('#item_' + treeName + '_id_show').val('');
	$('#item_' + treeName + '_check_icon').attr('disabled', true).prop('checked', false);
	$('#item_' + treeName + '_check_fav').attr('disabled', true).prop('checked', false);
	$('#item_' + treeName + '_check_mega').attr('disabled', true).prop('checked', false);
	$('#item_' + treeName + '_display').attr('disabled', true).prop('checked', false);
	$('#form_' + treeName).css('opacity', .5);

}
function editItem(treeName, modif) {
	debugmessage('editItem');
	debugmessage('#item_' + treeName + '_id');
	var item_obj = idGetItem($('#item_' + treeName + '_id').val(), getTreeByName(treeName));
	if (item_obj) {
		debugmessage('found');
		debugmessage(item_obj);
		var item_sel = {};
		var tree_id_name = '_' + treeName;
		if (treeName == 'menu') {
			tree_id_name = '';
		}
		item_sel.icon = $('#item_' + treeName + '_icon').val();
		item_sel.text = $('#item_' + treeName + '_name').val();
		item_sel.hint = $('#item_' + treeName + '_hint').val();
		item_sel.app = $('#item_' + treeName + '_link').val();
		if ($('#item_' + treeName + '_target').length > 0) {
			item_sel.link_target = $('#item_' + treeName + '_target').val();
		}
		if ($('#item_' + treeName + '_check_fav').length > 0) {
			if ($('#item_' + treeName + '_check_fav').is(':checked')) {
				item_sel.fav_check = 'S';
				updateFavSort();
			} else {
				item_sel.fav_check = 'N';
			}
		}
		if ($('#item_' + treeName + '_check_mega').length > 0) {
			if ($('#item_' + treeName + '_check_mega').is(':checked')) {
				item_sel.mega_check = 'S';
			} else {
				item_sel.mega_check = 'N';
			}
		}
		if ($('#item_' + treeName + '_check_icon').is(':checked')) {
			item_sel.icon_check = 'S';
		} else {
			item_sel.icon_check = 'N';
		}
		if(treeName == 'tb')
		{
			if ($('#item_' + treeName + '_display').is(':checked')) {
				item_sel.display = 'S';
			} else {
				item_sel.display = 'N';
			}
		}

		item_obj.assign(item_sel);

		if ($('#item_' + treeName + '_check_fav').length > 0) {
			if ($('#item_' + treeName + '_check_fav').is(':checked')) {
				updateFavSort();
			}
		}

		updateValueArr();
		if (modif && !stop_poll) {
			updateTreeIcons(getTreeByName(treeName));
			checkMegaMessage(item_obj.toObject(), item_obj, true);
			nm_form_modified();
		}
	}
}
function focusNode(node, skipLoad) {
	debugmessage('focusNode');
	var node_data = node.toObject();
	var treeName = getTreeName(node.tree());
	var node_dom = getNodeDom(node_data.id);
	$('.new_list.' + treeName + '_list .wholerow').removeClass('selected_item');
	node_dom.find('> .wholerow').addClass('selected_item');
	if (!skipLoad) {
		loadItem(node_data, node);
	}
}

function importAppList(str_import, str_field) {
	var batch_items = str_import.replaceAll('_!NM!_', '').split('__NM__');
	var tree = getTreeByName(str_field);
	var placeholder = JSON.parse(JSON.stringify(arr_placeholder));
	stop_poll = true;
	batch_items.forEach(function (item) {
		var app_name = item;
		var item_data = placeholder;
		item_data.text = app_name;
		item_data.app = app_name;
		createItem(tree, item_data);
	});

	stop_poll = false;
	updateTreeIcons(tree);
	updateValueArr(true);
}
function createItem(tree, item_data) {
	var item = getFocused(tree);
	var new_entry = JSON.parse(JSON.stringify(arr_placeholder));
	var id= getNextId(tree);
	var treeName = getTreeName(tree);
	var tree_id_name = '_' + treeName;
	if (treeName == 'menu') {
		tree_id_name = '';
	}
	if (typeof item_data == typeof {}) {
		new_entry.text = item_data.text;
		new_entry.app = item_data.app;
	} else {
		new_entry.text = 'Item ' + parseInt(id.replace('item' + tree_id_name + '_', '')) || (tree.available().toArray().length + 1);
	}
	new_entry.icon = 'fas fa-file';
	new_entry.id = id;

	if (!item || typeof item_data == typeof {}) {
		var nd = tree.addNode(new_entry)
		if (typeof item_data != typeof {}) {
			nd.select().focus();
		}
	} else {
		if (item.hasParent()) {
			var parent = item.getParent();
			var child = parent.addChild(new_entry);
			debugmessage(child.indexPath())
			debugmessage(getIndexFromPath(child.indexPath()))
			debugmessage(item.indexPath())
			debugmessage(parseInt(getIndexFromPath(item.indexPath()))+1)
			child = parent.getChildren().move(getIndexFromPath(child.indexPath()), parseInt(getIndexFromPath(item.indexPath()))+1)
			item.getParent().expand();
			if (typeof item_data != typeof {}) {
				child.select().focus();
			}
		} else {
			var n_item =  tree.insertAt(tree.indexOf(item)+1, new_entry);
			if (typeof item_data != typeof {}) {
				n_item.select().focus();
			}
		}
	}

	if (typeof item_data != typeof {}) {
		updateValueArr(true);
	}
	if (!stop_poll) {
		updateTreeIcons(tree);
	}
}

function createChild(tree) {
	var item = getFocused(tree);
	var id= getNextId(tree);
	var treeName = getTreeName(tree);
	var tree_id_name = '_' + treeName;
	if (treeName == 'menu') {
		tree_id_name = '';
	}
	if (!item) return false;
	var new_entry= JSON.parse(JSON.stringify(arr_placeholder));
	new_entry.icon = 'fas fa-file';
	new_entry.id = id;
	new_entry.text = 'Item '+ parseInt(id.replace('item' + tree_id_name + '_', '')) || (tree.available().toArray().length+1);
	var child = item.addChild(new_entry);
	item.expand();
	child.select().focus();
	updateValueArr(true);
	if (!stop_poll) {
		updateTreeIcons(tree);
	}
}
function debugmessage(anything) {
	if (debug) {
		console.log(anything);
	}
}
function moveUpItems(tree) {
	debugmessage('moveUpItems');
	if (!processing) {
		stop_poll = true;
		processing = true;
		try {
			var items = getSelected(tree);
			var treedom = getDomByTree(tree);
			var focus_id = getFocused(tree);
			var focus = false;
			var id_arr = [];
			if (items.length == 0) {

				processing = false;
				stop_poll = false;
				return false;
			}
			items.each(function(item) {
				var id = item.id;
				var sibling = item.previousVisibleSiblingNode();
				id_arr.push(id);
				if (sibling && !sibling.selected()) {
					item = item.swap(sibling);
					nm_form_modified();
				} else if (!sibling) {
					if (focus_id.id == item.id) {
						focus = true;
						focus_id = item.id;
					}
					if (item.hasParent()) {
						var parent = item.getParent();
						if (parent.hasParent()) {
							var sourceNode = parent.getParent();
							item = item.remove(true);
							item = sourceNode.addChild(item);
							item = sourceNode.getChildren().move(getIndexFromPath(item.indexPath()), getIndexFromPath(parent.indexPath())+1)
						} else {
							item = item.remove(true);
							item = tree.insertAt(tree.indexOf(parent)+1, item);
						}
						nm_form_modified();
						sibling = item.previousVisibleSiblingNode();
						if (sibling && !sibling.selected()) {
							item = item.swap(sibling);
						}
					}
					//termina aqui
				}
			});
			id_arr.forEach(function (id) {
				var item = tree.node(id);
				item.state('selected', true);
			});
			//começa aqui
			if (focus) {
				tree.node(focus_id).blur().focus();
			} else {
				//termina aqui
				if (focus_id && focus_id.focus) {
					focus_id.blur().focus();
				} else {
					debugmessage('###nofocus');
				}
			}
			processing = false;
			stop_poll = false;
		} catch (e) {
			debugmessage(e);
			processing = false;
			stop_poll = false;
		}
		treedom.scrollSelectedIntoView();
		updateTreeIcons(tree);
		updateValueArr(true);
	}
	else {
		debugmessage('deferred');
	}
}
function moveDownItems(tree) {
	debugmessage('moveDownItems');
	if (!processing) {
		processing = true;
		stop_poll = true;
		try {
			var items = getSelected(tree);
			var treedom = getDomByTree(tree);
			var focus_id = getFocused(tree);
			var focus = false;
			var id_arr = [];
			if (items.length == 0) {
				processing = false;
				stop_poll = false;
				return false;
			}
			items.toArray().reverse().forEach(function(item_id) {
				var item = tree.node(item_id.id);
				var id = item.id;
				var sibling = item.nextVisibleSiblingNode();
				id_arr.push(id);
				if (sibling && !sibling.selected()) {
					item = item.swap(sibling);
					nm_form_modified();
					//começa aqui
				} else if (!sibling) {
					if (focus_id.id == item.id) {
						focus = true;
						focus_id = item.id;
					}
					if (item.hasParent()) {
						var parent = item.getParent();
						if (parent.hasParent()) {
							var sourceNode = parent.getParent();
							item = item.remove(true);
							item = sourceNode.addChild(item);
							item = sourceNode.getChildren().move(getIndexFromPath(item.indexPath()), getIndexFromPath(parent.indexPath())+1)
						} else {
							item = item.remove(true);
							item = tree.insertAt(tree.indexOf(parent)+1, item);
						}
						nm_form_modified();
						// sibling = item.nextVisibleSiblingNode();
						// if (sibling && !sibling.selected()) {
						// 	item = item.swap(sibling);
						// }
					}
					//termina aqui
				}
			});
			id_arr.forEach(function (id) {
				var item = tree.node(id);
				item.state('selected', true);
			});
			//começa aqui
			if (focus) {
				tree.node(focus_id).blur().focus();
			} else {
				//termina aqui
				if (focus_id && focus_id.focus) {
					focus_id.blur().focus();
				} else {
					debugmessage('###nofocus');
				}
			}
			processing = false;
			stop_poll = false;
		} catch (e) {
			debugmessage(e);
			processing = false;
			stop_poll = false;
		}
		treedom.scrollSelectedIntoView();
		updateTreeIcons(tree);
		updateValueArr(true);
	}
	else {
		debugmessage('deferred');
	}
}
function indentItems(tree) {
	if (!processing) {
		processing = true;
		try {
			var items = getSelected(tree);
			var treedom = getDomByTree(tree);
			var id_arr = [];
			var focus_id = false;
			if (items.length == 0) return false;
			items.each(function(item) {
				var focus = isFocused(item);
				var id = item.id;
				var sibling = item.previousVisibleSiblingNode();
				id_arr.push(id);
				if (sibling) {
					item = item.remove(true);
					item = sibling.addChild(item);
					nm_form_modified();
				}
				if (focus) {
					focus_id = id;
				}
			});
			id_arr.forEach(function (id) {
				var item = tree.node(id);
				item.state('selected', true);
			});
			tree.expandDeep();
			if (focus_id !== false) {
				tree.node(focus_id).focus();
			}
			treedom.renderNodes();
			processing = false;
		} catch (e) {
			debugmessage(e);
			processing = false;
		}
		updateTreeIcons(tree);
		updateValueArr(true);
	}
}
function unIndentItems(tree) {
	if (!processing) {
		processing = true;
		try {
			var items = getSelected(tree);
			var treedom = getDomByTree(tree);
			var id_arr = [];
			var focus_id = false;
			if (items.length == 0) return false;
			items.toArray().reverse().forEach(function(item_id) {
				var item = tree.node(item_id.id);
				if (item.hasParent()) {
					var focus = isFocused(item);
					var parent = item.getParent();
					var id = item.id;
					id_arr.push(id);
					if (parent.hasParent()) {
						var sourceNode = parent.getParent();
						item = item.remove(true);
						item = sourceNode.addChild(item);
						item = sourceNode.getChildren().move(getIndexFromPath(item.indexPath()), getIndexFromPath(parent.indexPath())+1)
						nm_form_modified();
					} else {
						item = item.remove(true);
						item = tree.insertAt(tree.indexOf(parent)+1, item);
						nm_form_modified();
					}
					if (focus) {
						focus_id = id;
					}
				}
			});
			id_arr.forEach(function (id) {
				var item = tree.node(id);
				item.state('selected', true);
			});
			tree.expandDeep();
			if (focus_id !== false) {
				tree.node(focus_id).focus();
			}
			treedom.renderNodes();
			processing = false;
		} catch (e) {
			debugmessage(e);
			processing = false;
		}
		updateTreeIcons(tree);
		updateValueArr(true);
	}
}
function getIndexFromPath(path) {
	return path.split('.').pop()
}
function deleteItem(tree) {
	debugmessage('deleteItem')
	var items = getSelected(tree);
	var treeName = getTreeName(tree);
	var select_next = tree.selectFirstAvailableNode();
	if (!items) return false;
	stop_poll = true;
	items.forEach(function (item) {
		var id = item.toObject().id;
		var arr_to_filter = arr_val.shortcuts;
		arr_val.shortcuts = arr_to_filter.filter(function(val) {
			return val != id;
		});
		select_next = item.nextVisibleNode();
		if (!select_next) {
			select_next = item.previousVisibleNode();
		}
		item.remove();
	})
	lockEditor(treeName);
	try {
		select_next.select().focus();
	} catch (e) {
		// debugmessage(e);
	}
	stop_poll = false;
	updateValueArr(true);
}
function getSelected(tree) {
	debugmessage('getSelected');
	return tree.selected();
}
function getFocused(tree) {
	debugmessage('getFocused');
	var treeName = getTreeName(tree);
	var uid = $('.'+ treeName +'_list .selected_item').closest('li').attr('data-uid');
	return tree.node(uid);
}
function isFocused(node) {
	var tree = getTreeById(node);
	var treeName = getTreeName(tree);
	var uid = $('.'+ treeName +'_list .selected_item').closest('li').attr('data-uid');
	var node_uid = node.id;
	return (uid == node_uid);
}
function idBreakDown(id) {
	return id.replace('menu-item-', '').split('-');
}
function idGetItem(id, tree) {
	// var id_list = idBreakDown(id);
	var data_item = tree.node(id);
	// switch (id_list.length) {
	// 	case 1:
	// 		data_item = arr_items[id_list[0]];
	// 		break;
	// 	case 2:
	// 		data_item = arr_items[id_list[0]]['children'][id_list[1]];
	// 		break;
	// 	case 3:
	// 		data_item = arr_items[id_list[0]]['children'][id_list[1]]['children'][id_list[2]];
	// 		break;
	// }
	return data_item;
}
function updateFavSort() {
	debugmessage('updateFavSort')
	$('#sort_shortcuts').html('');
	// treeItens.flatten(function(){return true;}).forEach(function (node) {
	// 	var obj = node.toObject();
	// 	if (obj.fav_check == 'S' && (!obj.children || obj.children.length == 0)) {
	// 		if (arr_val.shortcuts.indexOf(obj.id) == -1 ) {
	// 			arr_val.shortcuts.push(obj.id);
	// 		}
	// 	} else {
	// 		var arr_to_filter = arr_val.shortcuts;
	// 		arr_val.shortcuts = arr_to_filter.filter(function(val) {
	// 			return val != obj.id;
	// 		});
	// 	}
	// });
	arr_val.shortcuts.forEach(function (obj_id) {
		var obj = idGetItem(obj_id, treeItens).toObject();
		var el_html = '';
		el_html += '<div class="sortingBlock" data-id="' + obj.id + '">';
		if (obj.icon_check == 'S') {
			el_html += '<i class="' + obj.icon + '"></i>';
		}
		el_html += '<span>' + obj.text + '</span>';
		el_html += '</div>';

		$('#sort_shortcuts').append(el_html);
	});
}
function checkedFav(treeName) {
	debugmessage('checkedFav');
	var check = $('#item_'+treeName+'_check_fav').is(':checked');
	var id = $('#item_'+treeName+'_id').val();
	var arr_to_filter = arr_val.shortcuts;
	if (check) {
		arr_val.shortcuts.push(id);
	} else {
		arr_val.shortcuts = arr_to_filter.filter(function(val) {
			return val != id;
		});
	}
	updateFavSort();
	updateValField(true);
}
function checkedMega(treeName) {
	debugmessage('checkedFav');
	var check = $('#item_'+treeName+'_check_mega').is(':checked');
	var id = $('#item_'+treeName+'_id').val();
	var tree = getTreeByName(treeName);
	var node = tree.node(id);
	var node_data = node.toObject();
	var node_dom = getNodeDom(node_data.id);

	updateValField(true);
}
function checkedIcon(treeName) {
	var check = $('#item_'+treeName+'_check_icon').is(':checked');
	if (check) {
		$('#item_' + treeName + '_icon').removeAttr('disabled');
	} else {
		$('#item_' + treeName + '_icon').attr('disabled', 'disabled');
	}
}
function loadTheme(modif) {
	var t_choice = themes_list[$('#theme_list').val()];
	if (t_choice) {
		$('#preview_swap').html(':root { --nm-primary-color: '+ t_choice.p +'; --nm-secondary-color: '+ t_choice.s +'; --nm-fontcolor-color: '+ t_choice.t +'; --nm-box-shadow: '+ t_choice.b +'; }');
		arr_val.theme = $('#theme_list').val();
		updateValueArr();

		if (modif && !stop_poll) {
			nm_form_modified();
		}
	}

}
function loadLayout(modif) {
	arr_val.layout = $('#layout_list').val();
	updateValueArr();

	if (modif && !stop_poll) {
		nm_form_modified();
	}

}
function checkUser(modif) {
	if ($('#user_check_enable').val() == 'S') {
		$('#user_partition_container').show();
	} else {
		$('#user_partition_container').hide();
	}
	if (modif && !stop_poll) {
		updateValueArr();
		nm_form_modified();
	}
}
function checkLayout(modif) {
	if ($('#layout_list').val() == 'H') {
		$('#enable_split').show();
		$('#enable_toolbar').hide();
		$('#user_menu_pos').hide();
		$('#start_expanded').hide();
	} else {
		$('#enable_split').hide();
		$('#enable_toolbar').show();
		$('#user_menu_pos').show();
		$('#start_expanded').show();
		checkToolbar(modif);
	}
	checkHeaderPos();
	if (modif && !stop_poll) {
		updateValueArr();
		nm_form_modified();
	}
}
function checkHeaderPos() {
	var is_horizontal = ($('#layout_list').val() == 'H');
	var has_split = $('#check_split').prop('checked');
	var has_tb = $('#check_toolbar').prop('checked');

	$('#enable_header_string_pos').show();
	$('#enable_header_string').show();
	if (is_horizontal) {
		$('#enable_header_string_pos').hide();
		if (!has_split) {
			$('#enable_header_string').hide();
		}
	} else {
		if (!has_tb) {
			$('#enable_header_string_pos').hide();
		}
	}

}
function checkToolbar(modif) {
	if (!($('#check_toolbar').prop('checked') && $('#layout_list').val() == 'V')) {
		$('#user_menu_pos').hide();
	} else {
		$('#user_menu_pos').show();
	}
	checkHeaderPos();
	if (modif && !stop_poll) {
		updateValueArr();
		nm_form_modified();
	}
}