<?php

function setHeaders() {
    $httpOrigin = (isset($_SERVER['HTTP_ORIGIN']) && !empty($_SERVER['HTTP_ORIGIN'])) ? $_SERVER['HTTP_ORIGIN'] : '';
    header('Content-Type: application/json');
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
    header('Access-Control-Max-Age: 1000');
    header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description, X-Requested-With');
}
function notifAjaxErrorHandler($ex) {
    ob_get_clean();
    showError($ex->getMessage(),'', '', $ex->getLine(), $ex->getFile(), true);
}
function checkAjaxRequest($app_obj,$menu_data) {
    $data = defineRequest();
    if (array_key_exists('ajax_notif_request', $data)) {
        set_exception_handler("notifAjaxErrorHandler");
        switch ($data['ajax_notif_request']) {
            case 'delete':
                if (!isset($data['notif_id']) || empty($data['notif_id'])) {
                    return sendResponse(['err_msg' => 'Missing ID'], 500);
                }
                deleteNotif($app_obj,$menu_data, $data['notif_id']);
                break;
            case 'read':
                if (!isset($data['notif_id']) || empty($data['notif_id'])) {
                    return sendResponse(['err_msg' => 'Missing ID'], 500);
                }
                markAsRead($app_obj,$menu_data, $data['notif_id']);
                break;
            case 'update':
                updateNotif($app_obj,$menu_data);
                break;
            case 'count':
                updateCount($app_obj,$menu_data);
                break;
            case 'all_read':
                markAsRead($app_obj,$menu_data, false);
                break;
            default:
                return sendResponse(['err_msg' => 'Request Unknown'], 500);
                break;
        }
        die;
    }
}
function sendResponse($data, $code = 200) {
    setHeaders();
    http_response_code($code);
    echo json_encode($data, 	1048576);
    die;
}
function defineRequest() {
    $data = $_REQUEST;
    try {
        $output = file_get_contents("php://input");
        json_decode($output);
        if (json_last_error() == JSON_ERROR_NONE && trim($output) != '') {
            $data = array_merge($data, json_decode($output, true));
        }
    } catch (Throwable $e) { sendResponse(['err_msg' => 'Unknown Error (defineRequest)'], 500); }
    return $data;
}
function updateNotif($app_obj,$menu_data) {
    $ret = getNotifRecords($app_obj, $menu_data, true);
    $output = [
        'msg' => '',
    ];
    if ($ret) {
        $n_count = 1;
        $n_lim = intval($menu_data['notif_limit']);
        if (!($n_lim >= 1)) {
            $n_lim = 10;
        }
        while (!$ret->EOF && $n_count <= $n_lim) {
            $output['msg'] .= buildNotif($ret->fetchRow(), $app_obj);
            $n_count++;
        }
    }

    sendResponse($output);
}
function updateCount($app_obj,$menu_data) {
    $ret = getNotifCount($app_obj, $menu_data, true);
    $output = [
        'msg' => '',
    ];
    if ($ret) {
        $output['msg'] = $ret->fetchRow()[0];
    }

    sendResponse($output);
}
function getNotifRecords($app_obj,$menu_data, $json_error = false) {
    $notif_login_var = eval('return "'.$menu_data['notif_login_var'].'";');
    $notif_data = $menu_data['notif_data'];
    $notif_conn_var = 'nm_db_'.$notif_data['notif_connection'];
//    $literal_char = '"';
    $dsnType = $app_obj->nm_tpbanco;
//    if ( in_array($dsnType, ['mysql', 'access']) ) {
//        $literal_char = '`';
//    }
    $cur_ts = 'CURRENT_TIMESTAMP';
    $sql_join = "
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType)." INNER JOIN ".trataCampoTabela_app($notif_data['notif_table'], $dsnType)." 
            ON ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_notif_id'], $dsnType)." = ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_id'], $dsnType)."
            "." INNER JOIN ".trataCampoTabela_app($notif_data['user_table'], $dsnType)." 
            ON ".trataCampoTabela_app($notif_data['user_table'], $dsnType).".".trataCampoTabela_app($notif_data['user_login'], $dsnType)." = ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_login_sender'], $dsnType)."
    ";
    if ( in_array($dsnType, ['access', 'ace_access']) ) {
        $cur_ts = 'NOW()';
        $sql_join = "
            (".trataCampoTabela_app($notif_data['inbox_table'], $dsnType)." INNER JOIN ".trataCampoTabela_app($notif_data['notif_table'], $dsnType)." 
            ON ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_notif_id'], $dsnType)." = ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_id'], $dsnType).")
            "." INNER JOIN ".trataCampoTabela_app($notif_data['user_table'], $dsnType)." 
            ON ".trataCampoTabela_app($notif_data['user_table'], $dsnType).".".trataCampoTabela_app($notif_data['user_login'], $dsnType)." = ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_login_sender'], $dsnType)."
    ";
    }
    if ( in_array($dsnType, ['informix', 'pdo_informix']) ) {
        $cur_ts = 'CURRENT';
    }
    if ( in_array($dsnType, ['sybase', 'pdo_sybase_dblib', 'pdo_sybase_odbc']) ) {
        $cur_ts = 'GETDATE()';
    }
    $sql = "
        SELECT 
            ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_message'], $dsnType).", 
            ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_title'], $dsnType).", 
            ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_login_sender'], $dsnType).", 
            ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_dtexpire'], $dsnType).", 
            ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_categ'], $dsnType).", 
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_isread'], $dsnType).", 
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_ontop'], $dsnType).", 
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_sent_date'], $dsnType).", 
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_tag'], $dsnType).", 
            ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_id'], $dsnType).",
            ".trataCampoTabela_app($notif_data['user_table'], $dsnType).".".trataCampoTabela_app($notif_data['user_login'], $dsnType).",
            ".trataCampoTabela_app($notif_data['user_table'], $dsnType).".".trataCampoTabela_app($notif_data['user_fullname'], $dsnType).",
            ".trataCampoTabela_app($notif_data['user_table'], $dsnType).".".trataCampoTabela_app($notif_data['user_image'], $dsnType).",
            ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_link'], $dsnType)."
        FROM 
            ".$sql_join."
        WHERE
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_userid'], $dsnType)." = '".$app_obj->{$notif_conn_var}->escape($notif_login_var)."'
            AND (
                ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_dtexpire'], $dsnType)." > ".$cur_ts."
                OR
                ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_dtexpire'], $dsnType)." IS NULL
            ) 
        ORDER BY 
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_ontop'], $dsnType)." DESC, 
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_sent_date'], $dsnType)." DESC 
    ";
//    $sql = "
//        select 
//            ".$literal_char.$notif_data['notif_table'].$literal_char.".".$literal_char.$notif_data['notif_message'].$literal_char.", 
//            ".$literal_char.$notif_data['notif_table'].$literal_char.".".$literal_char.$notif_data['notif_title'].$literal_char.", 
//            ".$literal_char.$notif_data['notif_table'].$literal_char.".".$literal_char.$notif_data['notif_login_sender'].$literal_char.", 
//            ".$literal_char.$notif_data['notif_table'].$literal_char.".".$literal_char.$notif_data['notif_dtexpire'].$literal_char.", 
//            ".$literal_char.$notif_data['notif_table'].$literal_char.".".$literal_char.$notif_data['notif_categ'].$literal_char.", 
//            ".$literal_char.$notif_data['inbox_table'].$literal_char.".".$literal_char.$notif_data['inbox_field_isread'].$literal_char.", 
//            ".$literal_char.$notif_data['inbox_table'].$literal_char.".".$literal_char.$notif_data['inbox_field_ontop'].$literal_char.", 
//            ".$literal_char.$notif_data['inbox_table'].$literal_char.".".$literal_char.$notif_data['inbox_field_sent_date'].$literal_char.", 
//            ".$literal_char.$notif_data['inbox_table'].$literal_char.".".$literal_char.$notif_data['inbox_field_tag'].$literal_char."
//        from 
//            ".$literal_char.$notif_data['inbox_table'].$literal_char." inner join ".$literal_char.$notif_data['notif_table'].$literal_char." 
//            on ".$literal_char.$notif_data['inbox_table'].$literal_char.".".$literal_char.$notif_data['inbox_field_notif_id'].$literal_char." = ".$literal_char.$notif_data['notif_table'].$literal_char.".".$literal_char.$notif_data['notif_id'].$literal_char."
//        where
//            ".$literal_char.$notif_data['inbox_table'].$literal_char.".".$literal_char.$notif_data['inbox_field_userid'].$literal_char." = '".$notif_login_var."'
//            and ".$literal_char.$notif_data['notif_table'].$literal_char.".".$literal_char.$notif_data['notif_dtexpire'].$literal_char." > CURRENT_TIMESTAMP 
//        order by 
//            ".$literal_char.$notif_data['inbox_table'].$literal_char.".".$literal_char.$notif_data['inbox_field_ontop'].$literal_char." desc, 
//            ".$literal_char.$notif_data['inbox_table'].$literal_char.".".$literal_char.$notif_data['inbox_field_sent_date'].$literal_char." desc 
//    ";
    $ret = $app_obj->{$notif_conn_var}->Execute($sql);

    if ($ret === false && !$ret->EOF && $GLOBALS["NM_ERRO_IBASE"] != 1) {
        showError($app_obj->Ini->Nm_lang['lang_errm_dber'], $app_obj->{$notif_conn_var}->ErrorMsg(), $sql, __LINE__, __FILE__, $json_error);
    }

    return $ret;
}
function getNotifCount($app_obj,$menu_data, $json_error = false) {
    $notif_login_var = eval('return "'.$menu_data['notif_login_var'].'";');
    $notif_data = $menu_data['notif_data'];
    $notif_conn_var = 'nm_db_'.$notif_data['notif_connection'];
    $dsnType = $app_obj->nm_tpbanco;
    $cur_ts = 'CURRENT_TIMESTAMP';
    $sql_join = "
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType)." INNER JOIN ".trataCampoTabela_app($notif_data['notif_table'], $dsnType)." 
            ON ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_notif_id'], $dsnType)." = ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_id'], $dsnType)."
            "." INNER JOIN ".trataCampoTabela_app($notif_data['user_table'], $dsnType)." 
            ON ".trataCampoTabela_app($notif_data['user_table'], $dsnType).".".trataCampoTabela_app($notif_data['user_login'], $dsnType)." = ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_login_sender'], $dsnType)."
    ";
    if ( in_array($dsnType, ['access', 'ace_access']) ) {
        $cur_ts = 'NOW()';
        $sql_join = "
            (".trataCampoTabela_app($notif_data['inbox_table'], $dsnType)." INNER JOIN ".trataCampoTabela_app($notif_data['notif_table'], $dsnType)." 
            ON ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_notif_id'], $dsnType)." = ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_id'], $dsnType).")
            "." INNER JOIN ".trataCampoTabela_app($notif_data['user_table'], $dsnType)." 
            ON ".trataCampoTabela_app($notif_data['user_table'], $dsnType).".".trataCampoTabela_app($notif_data['user_login'], $dsnType)." = ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_login_sender'], $dsnType)."
    ";
    }
    if ( in_array($dsnType, ['informix', 'pdo_informix']) ) {
        $cur_ts = 'CURRENT';
    }
    if ( in_array($dsnType, ['sybase', 'pdo_sybase_dblib', 'pdo_sybase_odbc']) ) {
        $cur_ts = 'GETDATE()';
    }
    $sql = "
        SELECT 
            COUNT(*)
        FROM 
            ".$sql_join."
        WHERE
            ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_userid'], $dsnType)." = '".$app_obj->{$notif_conn_var}->escape($notif_login_var)."'
            AND (
                ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_dtexpire'], $dsnType)." > ".$cur_ts."
                OR
                ".trataCampoTabela_app($notif_data['notif_table'], $dsnType).".".trataCampoTabela_app($notif_data['notif_dtexpire'], $dsnType)." IS NULL
            ) 
            AND (
                ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_isread'], $dsnType)." = 0
                OR
                ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType).".".trataCampoTabela_app($notif_data['inbox_field_isread'], $dsnType)." IS NULL
            )
    ";
    $ret = $app_obj->{$notif_conn_var}->Execute($sql);

    if ($ret === false && !$ret->EOF && $GLOBALS["NM_ERRO_IBASE"] != 1) {
        showError($app_obj->Ini->Nm_lang['lang_errm_dber'], $app_obj->{$notif_conn_var}->ErrorMsg(), $sql, __LINE__, __FILE__, $json_error);
    }

    return $ret;
}
function deleteNotif($app_obj,$menu_data, $notif_id) {
    $notif_login_var = eval('return "'.$menu_data['notif_login_var'].'";');
    $notif_data = $menu_data['notif_data'];
    $notif_conn_var = 'nm_db_'.$notif_data['notif_connection'];
    $dsnType = $app_obj->nm_tpbanco;
    $sql = "
        DELETE FROM ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType)."
        WHERE
            ".trataCampoTabela_app($notif_data['inbox_field_userid'], $dsnType)." = '".$app_obj->{$notif_conn_var}->escape($notif_login_var)."'
            AND ".trataCampoTabela_app($notif_data['inbox_field_notif_id'], $dsnType)." = ".$app_obj->{$notif_conn_var}->escape($notif_id)."
    ";
    $ret = $app_obj->{$notif_conn_var}->Execute($sql);

    if ($ret === false && !$ret->EOF && $GLOBALS["NM_ERRO_IBASE"] != 1) {
        showError($app_obj->Ini->Nm_lang['lang_errm_dber'], $app_obj->{$notif_conn_var}->ErrorMsg(), $sql, __LINE__, __FILE__, true);
    }

    sendResponse(['msg' => 'success']);
}
function markAsRead($app_obj,$menu_data, $notif_id)
{
    $notif_login_var = eval('return "'.$menu_data['notif_login_var'].'";');
    $notif_data = $menu_data['notif_data'];
    $notif_conn_var = 'nm_db_'.$notif_data['notif_connection'];
    $dsnType = $app_obj->nm_tpbanco;
    $cur_ts = 'CURRENT_TIMESTAMP';
    if ( in_array($dsnType, ['access', 'ace_access']) ) {
        $cur_ts = 'NOW()';
    }
    if ( in_array($dsnType, ['informix', 'pdo_informix']) ) {
        $cur_ts = 'CURRENT';
    }
    if ( in_array($dsnType, ['sybase', 'pdo_sybase_dblib', 'pdo_sybase_odbc']) ) {
        $cur_ts = 'GETDATE()';
    }
    $sql = "
        UPDATE ".trataCampoTabela_app($notif_data['inbox_table'], $dsnType)."
        SET 
            ".trataCampoTabela_app($notif_data['inbox_field_isread'], $dsnType)." = 1,
            ".trataCampoTabela_app($notif_data['inbox_field_ontop'], $dsnType)." = 0,
            ".trataCampoTabela_app($notif_data['inbox_field_read_date'], $dsnType)." = ".$cur_ts."
        WHERE
            ".trataCampoTabela_app($notif_data['inbox_field_userid'], $dsnType)." = '".$app_obj->{$notif_conn_var}->escape($notif_login_var)."'
    ";
    if ($notif_id !== false) {
        $sql .= "
            AND " . trataCampoTabela_app($notif_data['inbox_field_notif_id'], $dsnType) . " = " . $app_obj->{$notif_conn_var}->escape($notif_id) . " 
        ";
    } else {
        $sql .= "
            AND (
            (
                " . trataCampoTabela_app($notif_data['inbox_field_isread'], $dsnType) . " = 0
                OR
                " . trataCampoTabela_app($notif_data['inbox_field_isread'], $dsnType) . " IS NULL
            ) 
            OR " . trataCampoTabela_app($notif_data['inbox_field_ontop'], $dsnType) . " = 1 )
        ";
    }
    $ret = $app_obj->{$notif_conn_var}->Execute($sql);

    if ($ret === false && !$ret->EOF && $GLOBALS["NM_ERRO_IBASE"] != 1) {
        showError($app_obj->Ini->Nm_lang['lang_errm_dber'], $app_obj->{$notif_conn_var}->ErrorMsg(), $sql, __LINE__, __FILE__, true);
    }
    sendResponse(['msg' => 'success']);
}

function showError($msg, $err, $sql, $line, $file, $json_error = false) {
    if ($json_error) {
        $ret_json = [
            'err_msg' => $msg,
            'error' => $err,
//            'line' => $line,
//            'file' => $file,
//            'sql' => $sql,
        ];
        sendResponse($ret_json, 500);
    } else {
    ?>
        <err-msg err-line="<?php echo $line; ?>" err-file="<?php echo $file; ?>">
            <p><?php echo $msg; ?></p>
            <p style="text-align: left;"><?php echo $err; ?></p>
            <br />
            <pre style="text-align: left; font-size: .650em;"><?php /*echo $sql;*/ ?></pre>
        </err-msg>
        <?php
    }
}
function humanTimeString($time_in, $obj) {
    $timestamp = strtotime($time_in);
    $dt = new DateTime();
    date_timestamp_set($dt,$timestamp);
    $obj->nm_data->SetaData($dt->format('Y-m-d'), "YYYY-MM-DD");
    $out_date = $obj->nm_data->FormataSaida($obj->nm_data->FormatRegion("DT", "" . $_SESSION['scriptcase']['reg_conf']['date_format'] . ""));

    $mm = 60;
    $h = $mm * 60;
    $d = $h * 24;
    $m = 30 * $d;
    $y = 12 * $m;

    $cur_time = time();

    $today = getdate($cur_time)['mday'];
    $in_date = getdate($timestamp)['mday'];

    $daydiff = ($today - $in_date);

    $timediff = floor($cur_time - $timestamp);
    if ($timediff < 2 ) return $obj->Nm_lang['lang_human_time_just_now'];
    if ($timediff < 1 * $mm) return sprintf($obj->Nm_lang['lang_human_time_seconds_ago'], $timediff);
    if ($timediff < 2 * $mm) return $obj->Nm_lang['lang_human_time_minute_ago'];
    if ($timediff < 59 * $mm) return sprintf($obj->Nm_lang['lang_human_time_amount_minutes_ago'], round($timediff / $mm));
    if ($timediff < 90 * $mm) return $obj->Nm_lang['lang_human_time_hour_ago'];
    if ($timediff < 6 * $h) return sprintf($obj->Nm_lang['lang_human_time_amount_hours_ago'], round($timediff / $h));
    if ($timediff < 23 * $h && $daydiff == 0) return $obj->Nm_lang['lang_human_time_today'];
    if ($timediff < 48 * $h && $daydiff == 1) return $obj->Nm_lang['lang_human_time_yesterday'];
//    if ($timediff < 30 * $d) return sprintf($obj->Nm_lang['lang_human_time_amount_days_ago'], round($timediff / $d));
//    if ($timediff < 45 * $d) return $obj->Nm_lang['lang_human_time_last_month'];
//    if ($timediff < 11 * $m) return sprintf($obj->Nm_lang['lang_human_time_amount_months_ago'], round($timediff / $m));
//    if ($timediff < 18 * $m) return $obj->Nm_lang['lang_human_time_last_year'];
//    return sprintf($obj->Nm_lang['lang_human_time_amount_years_ago'], round($timediff / $y));
    return $out_date;
}
function sanitizeSpecChars($in_str)
{
    $data = defineRequest();
    if (empty($in_str)) {
        return '';
    }
    if (!(array_key_exists('ajax_notif_request', $data))) {
        if (mb_check_encoding($in_str, 'UTF-8')) {
            return sc_convert_encoding($in_str, $_SESSION['scriptcase']['charset'], 'UTF-8');
        } else {
            return $in_str;
        }
    } else {
        if (mb_check_encoding($in_str, $_SESSION['scriptcase']['charset']) && !mb_check_encoding($in_str, 'UTF-8')) {
            $in_str = sc_convert_encoding($in_str, 'UTF-8', $_SESSION['scriptcase']['charset']);
        }
        $out = json_encode($in_str, 2097152);
        $out = substr($out, 1, -1);
        $out = str_replace('\\/','/',  $out);
        $out = preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($match) {
            return '&#x'.$match[1].';';
        }, $out);
        return $out;
    }
}
function random_string($length, $str = null) {
    if (empty($str)) {
        $str = random_bytes($length);
    }
    $str = base64_encode(md5($str));
    $str = str_replace(["+", "/", "="], "", $str);
    $str = substr($str, 0, $length);
    return $str;
}
function buildNotif($notif_item,$app_obj) {
    $read_item = 'false';
    $ontop_item = 'false';
    if ($notif_item[5] == 1) {
        $read_item = 'true';
    }
    if ($notif_item[6] == 1) {
        $ontop_item = 'true';
    }
    $link_data = trim($notif_item[13]);
    $hash = random_string(15, $notif_item[9]);
    if (empty($link_data)) {
        $click_action = "openNotification('".$hash."');";
    } else {
        if ( filter_var($link_data, FILTER_VALIDATE_URL) ) {
            $click_action = "openLink('".$link_data."', '".$hash."');";
        } else {
            $click_action = "openApp('".$link_data."', '".$hash."');";
        }
    }


    ob_start();
    ?><div id="<?php echo $hash; ?>" data-notif-id="<?php echo $notif_item[9]; ?>" onclick="<?php echo $click_action; ?>" class="notification-item" data-read="<?php echo $read_item; ?>" data-ontop="<?php echo $ontop_item; ?>">
        <div class="m-right-4">
            <div class="avatar">
                <img src="<?php echo imageToURL($notif_item[12]); ?>" title="<?php echo sanitizeSpecChars($notif_item[11]); ?>" />
            </div>
        </div>
        <div class="content">
            <div class="title m-bottom-1"><?php echo sanitizeSpecChars($notif_item[1]); ?></div>
            <?php
                if (is_string($notif_item[0])) {
                    $message_str = $notif_item[0];
                } else {
                    $message_str = stream_get_contents($notif_item[0]);
                }
            ?>
            <div class="body m-bottom-0"><?php echo $message_str; ?></div>
            <small class="time"><?php echo sanitizeSpecChars(humanTimeString($notif_item[7], $app_obj));?></small>
        </div>
        <div class="m-left-4 signs">
            <i class="fa-solid fa-thumbtack" title="<?php echo sanitizeSpecChars($app_obj->Nm_lang['lang_notifications_ontop_hint']); ?>"></i>
            <a class="read-sign" href="javascript:void(0)" title="<?php echo sanitizeSpecChars($app_obj->Nm_lang['lang_notifications_unread_hint']); ?>"></a>
        </div>
        <a class="notification-close" href="javascript:void(0)">
            <i class="lni lni-close"></i>
        </a>
        <div class="confirm-exclude">
            <div class="confirm-exclude-label">
                <?php echo sanitizeSpecChars($app_obj->Nm_lang['lang_notifications_delete_message']); ?>
            </div>
            <div class="confirm-exclude-actions">
                <button class="button action-button ok-confirm">
                    <i class="mb_icon fas fa-check" aria-hidden="true"></i>
                    <?php echo sanitizeSpecChars($app_obj->Nm_lang['lang_notifications_delete_confirm']); ?>
                </button>
                <button class="button action-button cancel-confirm">
                    <i class="mb_icon fas fa-close" aria-hidden="true"></i>
                    <?php echo sanitizeSpecChars($app_obj->Nm_lang['lang_notifications_delete_cancel']); ?>
                </button>
            </div>
        </div>
        <script>
            if ($('#<?php echo $hash; ?> .avatar img').attr('src') == '') {
                $('#<?php echo $hash; ?> .avatar img').attr('src', generateAvatar('<?php echo sanitizeSpecChars($notif_item[11]); ?>'));
            }

            $('#<?php echo $hash; ?> .content .body').attr('title', $('#<?php echo $hash; ?> .content .body').text());
        </script>
    </div><?php
    return ob_get_clean();
}
checkAjaxRequest($this, $menu_data);
?>